/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate.fabric;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistryObject<T>
implements Supplier<T> {
    private static RegistryObject<?> EMPTY = new RegistryObject();
    private final class_2960 id;
    @Nullable
    private T object;

    private RegistryObject() {
        this.id = null;
    }

    private RegistryObject(class_2960 id, class_2378<? super T> registry) {
        Objects.requireNonNull(registry);
        this.id = id;
        this.object = registry.method_10223(this.id);
    }

    public static <T> RegistryObject<T> of(class_2960 id, class_2378<? super T> registry) {
        return new RegistryObject<T>(id, registry);
    }

    public static <T, U extends T> RegistryObject<U> create(class_2960 name, class_2960 registryName, String modid) {
        return new RegistryObject<T>(name, (class_2378)class_7923.field_41167.method_10223(registryName));
    }

    public static <T> RegistryObject<T> empty() {
        return EMPTY;
    }

    @Override
    @NotNull
    public T get() {
        Objects.requireNonNull(this.object);
        return this.object;
    }

    public class_2960 getId() {
        return this.id;
    }

    public void updateReference(class_2378<? super T> registry) {
        this.object = registry.method_10223(this.getId());
    }

    public boolean isPresent() {
        return this.object != null;
    }

    public void ifPresent(Consumer<? super T> consumer) {
        if (this.isPresent()) {
            consumer.accept(this.get());
        }
    }

    public Stream<T> stream() {
        return this.isPresent() ? Stream.of(this.get()) : Stream.of(new Object[0]);
    }

    public RegistryObject<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (this.isPresent() && !predicate.test(this.get())) {
            return RegistryObject.empty();
        }
        return this;
    }

    public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isPresent()) {
            return Optional.ofNullable(mapper.apply(this.get()));
        }
        return Optional.empty();
    }

    public <U> Optional<U> flatMap(Function<? super T, Optional<U>> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isPresent()) {
            return Objects.requireNonNull(mapper.apply(this.get()));
        }
        return Optional.empty();
    }

    public <U> Supplier<U> lazyMap(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return () -> this.isPresent() ? mapper.apply((T)this.get()) : null;
    }

    public T orElse(T other) {
        return this.isPresent() ? this.get() : other;
    }

    public T orElseGet(Supplier<? extends T> other) {
        return this.isPresent() ? this.get() : other.get();
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent()) {
            return this.get();
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RegistryObject) {
            return Objects.equals(((RegistryObject)obj).id, this.id);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }
}

